import React from "react";
import { BrowserRouter, Link, Route, Routes } from "react-router-dom";
import Home from "./pages/Home";
import Favorites from "./pages/Favorites";

export const App = () => {
  return (
    <BrowserRouter>
      {/* Navbar */}
      <nav className="flex items-center gap-8 px-8 py-4 bg-gradient-to-r from-purple-600 via-pink-500 to-orange-500 shadow-lg">
        <Link
          to="/"
          className="text-white font-semibold hover:scale-110 transition-transform duration-200 relative group"
        >
          Home
          <span className="absolute bottom-0 left-0 w-0 h-0.5 bg-white group-hover:w-full transition-all duration-300"></span>
        </Link>
        <Link
          to="/favorites"
          className="text-white font-semibold hover:scale-110 transition-transform duration-200 relative group"
        >
          Favorites
          <span className="absolute bottom-0 left-0 w-0 h-0.5 bg-white group-hover:w-full transition-all duration-300"></span>
        </Link>
      </nav>
      <Routes>
        <Route path="/" element={<Home />} />
        <Route path="/favorites" element={<Favorites />} />
      </Routes>
    </BrowserRouter>
  );
};
